define(['angular', 'app', 'delayManager'], function (angular, app) {
	'use strict';

	app.controller('MainController', function ($q, $scope, $rootScope, globalDelayTracker, $modal) {
     	$scope.$watch(function () {
			return $('body').hasClass('modal-open');
		}, function (isModalOpen) {
			$('div.container').attr("aria-hidden", isModalOpen);
		});

		// Auxiliary promise based on promise tracker active state (to feed the cg-busy)
		var deferred = $q.defer();
		$rootScope.delayed = deferred.promise;

		$rootScope.$watch(globalDelayTracker.active, function (newIsActive, oldIsActive) {
			
			if (newIsActive && !oldIsActive) {
				deferred = $q.defer();
				$rootScope.delayed = deferred.promise;
			} else if(!newIsActive && oldIsActive) {
				deferred.resolve('finished');
			}
		});

		if (!Modernizr.audio ||
			!Modernizr.canvas ||
			!Modernizr.csstransforms3d ||
			!Modernizr.csstransitions ||
			!Modernizr.textshadow ||
			!Modernizr.rgba ||
			!Modernizr.opacity ||
			!Modernizr.boxshadow ||
			!Modernizr.borderradius ||
			!Modernizr.fontface) {

			$modal.open({
				templateUrl: 'browserwarning_template.html',
				backdrop: 'static',
				keyboard: false,
				controller: function($scope, $modalInstance) {
					$scope.continueToApp = function() {
						$modalInstance.dismiss();
					};
				}
			});
		}	

	});

});